/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: BreakPoint.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// BreakPoint.h: interface for the CBreakPoint class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BREAKPOINT_H__D3D297DA_8A1B_427E_ACCD_791DE5327EE2__INCLUDED_)
#define AFX_BREAKPOINT_H__D3D297DA_8A1B_427E_ACCD_791DE5327EE2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <afxtempl.h>

enum {BREAKPOINT_ADDRESS = 1, BREAKPOINT_MEMORY_ACCES = 2};

//////////////////////////////////////////////////////////////////////
class CBreakPoint  
{
	int					m_type;
	WORD				m_breakAddress;

public:
	CBreakPoint ();
	CBreakPoint (WORD addr);
	virtual ~CBreakPoint();

	BOOL				IsAddress () {return m_type | BREAKPOINT_ADDRESS;}
	WORD				GetAddress () {return m_breakAddress;}
};

typedef CList<CBreakPoint, CBreakPoint&> CBreakPointList;

#endif // !defined(AFX_BREAKPOINT_H__D3D297DA_8A1B_427E_ACCD_791DE5327EE2__INCLUDED_)
