/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Board_FDD.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// Board_FDD.h: interface for the CMotherBoard_FDD class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BOARD_FDD_H__BA5F7B33_7907_452E_B4FF_0450AD45C2AF__INCLUDED_)
#define AFX_BOARD_FDD_H__BA5F7B33_7907_452E_B4FF_0450AD45C2AF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Board.h"

//////////////////////////////////////////////////////////////////////
class CMotherBoard_FDD : public CMotherBoard  
{
	enum {FDD_NOERROR = 0, FDD_DISK_PROTECTED, FDD_SECT_HEADER_ERROR, FDD_0_TRACK_ERROR,
			FDD_POSITIONING_ERROR, FDD_SECTOR_NOT_FOUND, FDD_NO_DISK, FDD_STOP,
			FDD_ADDR_MARKER_NOT_FOUND, FDD_DATA_MARKER_NOT_FOUND, FDD_BAD_FORMAT};

	struct TABLE
	{
		WORD				unknown1;				//0
		WORD				cur_track_num;			//2
		WORD				cur_track_tab[2];		//4
		WORD				sob_delay;				//10
		WORD				track_to_track_delay;	//12
		BYTE				predcomp_track_num;		//14
		BYTE				try_num;				//15
		BYTE				unknown2;				//16
		BYTE				format_code;			//17
		WORD				sign_pointer;			//20
		WORD				sign_tab[2];			//22
		WORD				working_addr;			//26
		short				working_length;			//30
		BYTE				disk_side_num;			//32
		BYTE				track_num;				//33
		BYTE				drive_num;				//34
		BYTE				sector_num;				//35
		WORD				unknown3[9];			//36
		WORD				sector_per_track;		//60
	};

	CString				m_strDrives[4];

	BOOL				m_bBasic;
	BYTE*				m_pBasic;
	BYTE*				m_pExt;
	
	void				SetMemoryPage (BOOL bBasic);
	BOOL				IsBasicPage () {return m_bBasic;}

	void				EmulateFDD ();
	void				ReadDrivesPath ();

	// Initialize memory
	virtual void		InitMemoryModules ();
	
	// Methods for loading and saving emulator state
	virtual BOOL		RestoreState (CMSFManager& msf, HBITMAP hScreenshot);
	
	// Methods for Set/Get byte/word
	virtual void		SetByte (int addr, BYTE value);
	virtual void		SetWord (int addr, WORD value);
	virtual BOOL		IsRegister (int addr);
	
	// Methods emulate registers bihaviour
	virtual void		OnSetSystemRegister (WORD num, WORD* pDst, WORD src);

	virtual	void		Interception (); // Called after each command

public:
	CMotherBoard_FDD();
	virtual ~CMotherBoard_FDD();

	virtual DWORD		GetConfiguration () {return MSF_CONF_BK1001_FDD;}

};

#endif // !defined(AFX_BOARD_FDD_H__BA5F7B33_7907_452E_B4FF_0450AD45C2AF__INCLUDED_)
