/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Board_EXT32.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// Board_EXT32.h: interface for the CMotherBoard_EXT32 class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BOARD_EXT32_H__AB5B4F33_10EA_4E4D_BB81_D99D2A1C8EC0__INCLUDED_)
#define AFX_BOARD_EXT32_H__AB5B4F33_10EA_4E4D_BB81_D99D2A1C8EC0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Board.h"

//////////////////////////////////////////////////////////////////////
class CMotherBoard_EXT32 : public CMotherBoard  
{
protected:
	DWORD				m_nPage;
	BYTE*				m_pExt;

	void				SetMemoryPage (int nPage);

	// Initialize memory
	virtual void		InitMemoryModules ();

	// Methods for loading and saving emulator state
	virtual BOOL		RestoreState (CMSFManager& msf, HBITMAP hScreenshot);

	// Methods for Set/Get byte/word
	virtual void		SetByte (int addr, BYTE value);
	virtual void		SetWord (int addr, WORD value);
	
public:
	CMotherBoard_EXT32();
	virtual ~CMotherBoard_EXT32();

	virtual DWORD		GetConfiguration () {return MSF_CONF_BK1001_EXT32;}
};

#endif // !defined(AFX_BOARD_EXT32_H__AB5B4F33_10EA_4E4D_BB81_D99D2A1C8EC0__INCLUDED_)
