/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Board_EXT32.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// Board_EXT32.cpp: implementation of the CMotherBoard_EXT32 class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "BK.h"
#include "Board_EXT32.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMotherBoard_EXT32::CMotherBoard_EXT32()
{
}

CMotherBoard_EXT32::~CMotherBoard_EXT32()
{
	delete []m_pExt;
}



//////////////////////////////////////////////////////////////////////
void CMotherBoard_EXT32::InitMemoryModules ()
{
	LoadRomModule (IDS_INI_MONITOR, 0100000);
	
	m_nPage = 3;
	m_pExt = new BYTE [8192 * 4];
}



//////////////////////////////////////////////////////////////////////
void CMotherBoard_EXT32::SetByte (int addr, BYTE value)
{
	addr = ConvertAddress (addr);

	int iMemPage = addr >> 13;

	// memory on 0 - 040000
	if ((iMemPage >= 0 && iMemPage < 2) || iMemPage == 8)
	{
		m_pMemory[addr] = value;
		return;
	}

	// screen memory on 040000 - 0100000
	if (iMemPage >= 2 && iMemPage < 4)
	{
		OnSetScreenCell (addr, value);
		m_pMemory[addr] = value;
		return;
	}

	// monitor on 0100000 - 0120000
	if (iMemPage >= 4 && iMemPage < 5)
	{
		SetMemoryPage (value & 3);
		return;
	}

	// memory on 0120000 - 0140000
	if (iMemPage >= 5 && iMemPage < 6)
	{
		m_pMemory[addr] = value;
		return;
	}

	// ROM memory on 0140000 - 0160000
	if (iMemPage >= 6 && iMemPage < 7)
		throw CExceptionHalt (addr, "Can't write this address.");

	if (IsRegister (addr))
		OnSetSystemRegister (addr, (WORD*)&m_pMemory[addr], value);
	else
		throw CExceptionHalt (addr, "Can't write this address.");
}



//////////////////////////////////////////////////////////////////////
void CMotherBoard_EXT32::SetWord (int addr, WORD value)
{
	addr = ConvertAddress (addr);

	int iMemPage = addr >> 13;
	addr &= 0377776;

	// memory on 0 - 040000
	if ((iMemPage >= 0 && iMemPage < 2) || iMemPage == 8)
	{
		*(WORD*)&m_pMemory[addr] = value;
		return;
	}

	// screen memory on 040000 - 0100000
	if (iMemPage >= 2 && iMemPage < 4)
	{
		OnSetScreenCell (addr, value);
		*(WORD*)&m_pMemory[addr] = value;
		return;
	}

	// monitor on 0100000 - 0120000
	if (iMemPage >= 4 && iMemPage < 5)
	{
		SetMemoryPage (value & 3);
		return;
	}

	// memory on 0120000 - 0140000
	if (iMemPage >= 5 && iMemPage < 6)
	{
		*(WORD*)&m_pMemory[addr] = value;
		return;
	}

	// ROM memory on 0140000 - 0160000
	if (iMemPage >= 6 && iMemPage < 7)
		throw CExceptionHalt (addr, "Can't write this address.");

	if (IsRegister (addr))
		OnSetSystemRegister (addr, (WORD*)&m_pMemory[addr], value);
	else
		throw CExceptionHalt (addr, "Can't write this address.");
}



//////////////////////////////////////////////////////////////////////
void CMotherBoard_EXT32::SetMemoryPage (int nPage)
{
	memcpy (&m_pExt[8192 * m_nPage], &m_pMemory[8192 * 5], 8192);
	m_nPage = nPage;
	memcpy (&m_pMemory[8192 * 5], &m_pExt[8192 * m_nPage], 8192);
}



//////////////////////////////////////////////////////////////////////
BOOL CMotherBoard_EXT32::RestoreState (CMSFManager& msf, HBITMAP hScreenshot)
{
	if (!CMotherBoard::RestoreState (msf, hScreenshot))
		return FALSE;

	if (msf.IsLoad ())
	{
		if (!msf.GetBlockExt32Memory (&m_nPage, m_pExt))
			return FALSE;
	}
	else
	{
		if (!msf.SetBlockExt32Memory (m_nPage, m_pExt))
			return FALSE;
	}

	return TRUE;
}
