/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: Board.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// Board.h: interface for the CMotherBoard class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BOARD_H__57FB6DA8_995C_4883_A809_D70A113CFDAE__INCLUDED_)
#define AFX_BOARD_H__57FB6DA8_995C_4883_A809_D70A113CFDAE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//////////////////////////////////////////////////////////////////////
#include <afxtempl.h>

#include "Device.h"
#include "CPU.h"
#include "MSF.h"
#include "MSFManager.h"
#include "ExceptionHalt.h"
#include "ExceptionFile.h"

//////////////////////////////////////////////////////////////////////
class CMotherBoard : public CDevice
{
protected:
	enum				{SPEED_PRECISION = 1024};
	enum				{SPEED_STEP = 512};
	
	CCPU				m_cpu;		// Main CPU
	BYTE*				m_pMemory;	// Base 64K memory

	CDevice*			m_pScreen;	// BK Screen 
	CDevice*			m_pSpeaker;	// BK Speaker
	CDevice*			m_pCovox;	// BK Covox
	CDevice*			m_pFDD;		// BK Floppy controller
	CDevice*			m_pDebugger;// Abstract debugger device

	CWnd*				m_pParent;
	BOOL				m_bRunning;	// Rinning state
	BOOL				m_bNextCircleInterrupt4; // If set - make interrupt 4
	BOOL				m_bAskForBreak;
	int					m_nMultiplier; // Speed multiplier
	WORD				m_startAddr; // CPU start address

	WORD				m_fKeyboardInterrupt;
		
	// Debug section
	enum				{ADDRESS_NONE = -1, GO_INTO = -2, GO_OUT = -3};

	WORD				m_previousPC;
	int					m_fGotoAddress;
	
	//BOOL				ConvertSrcToString (WORD instr, WORD addr, CString& strSrc, WORD& code);
	//BOOL				ConvertDstToString (WORD instr, WORD addr, CString& strDst, WORD& code);


	void				LoadRomModule (int iniRomNameIndex, WORD addr);

	// Initialize memory
	virtual void		InitMemoryModules ();
	
	// Methods for loading and saving emulator state
	virtual BOOL		RestoreRegisters (CMSFManager& msf);
	virtual BOOL		RestoreMemory (CMSFManager& msf);
	virtual BOOL		RestorePreview (CMSFManager& msf, HBITMAP hScreenshot);
	
	// Virtual method called after reset command
	virtual void		OnReset ();

	// Methods for Set/Get byte/word
	virtual BYTE		GetByte (int addr);
	virtual WORD		GetWord (int addr);
	virtual void		GetByte (int addr, BYTE* pValue);
	virtual void		GetWord (int addr, WORD* pValue);
	virtual void		SetByte (int addr, BYTE value);
	virtual void		SetWord (int addr, WORD value);
	virtual BOOL		IsRegister (int addr);
	
	// Methods emulate registers bihaviour
	virtual void		OnSetSystemRegister (WORD num, WORD* pDst, WORD src);
	virtual void		OnGetSystemRegister (WORD num);
	virtual	void		OnSetScreenCell (WORD addr, BYTE byte);
	virtual	void		OnSetScreenCell (WORD addr, WORD word);

	virtual	void		Interception (); // Called after each command
	void				Timerprocess (); // Called after each command
	
public:
	CMotherBoard();
	virtual ~CMotherBoard();

	virtual DWORD		GetConfiguration () {return MSF_CONF_BK1001;}
	virtual BOOL		RestoreState (CMSFManager& msf, HBITMAP hScreenshot);
	
	BYTE				GetByteIndirect (int addr);
	WORD				GetWordIndirect (int addr);
	void				SetByteIndirect (int addr, BYTE value);
	void				SetWordIndirect (int addr, WORD value);
	WORD				GetPSW ();
	void				SetPSW (WORD value);
	WORD				GetPrevPC () {return m_previousPC;}

	void				AttachWindow (CWnd* pParent);
	void				AttachScreen (CDevice* pDevice) {m_pScreen = pDevice;}
	void				AttachSpeaker (CDevice* pDevice) {m_pSpeaker = pDevice;}
	void				AttachCovox (CDevice* pDevice) {m_pCovox = pDevice;}
	void				AttachFDD (CDevice* pDevice) {m_pFDD = pDevice;}
	void				AttachDebugger (CDevice* pDevice) {m_pDebugger = pDevice;}
	
	//void				ExternalInterrupt (WORD interrupt); // For external use only
	void				StopInterrupt ();
	void				KeyboardInterrupt (WORD interrupt);
	int					ExecuteNextInstruction (); // Return number of ticks
	void				ExecuteInstructionSet (int count, BOOL bCount = TRUE); // Execute insructions set

	int					DebugInstruction (WORD addr, CString& strInstr, CString& strArg, WORD* codes);
	void				RefreshScreen ();

	void				MakeInterrupt (WORD interrupt);
	void				ResetHot (WORD addrStart);
	void				ResetCold (WORD addrStart);
	void				RunCPU ();
	void				RunInto ();
	void				RunOver ();
	void				RunOut ();
	void				RunToAddr (WORD addr);
	void				StopCPU ();
	void				BreakCPU ();
	BOOL				IsCPURun ();
	void				AccelerateCPU ();
	void				SlowdownCPU ();
	void				NormalizeCPU ();
	BOOL				CanAccelerate ();
	BOOL				CanSlowDown ();
	LONGLONG			GetCPUTick () {return m_tickCount;}
	void				SetCPUSpeed (float speed) {m_nMultiplier = (int)(speed * SPEED_PRECISION);}
	float				GetCPUSpeed ();
	void				EnableAskForBreak (BOOL bEnable) {m_bAskForBreak = bEnable;}
	BOOL				IsAskForBreak () {return m_bAskForBreak;}

	friend class		CCPU;
};

#endif // !defined(AFX_BOARD_H__57FB6DA8_995C_4883_A809_D70A113CFDAE__INCLUDED_)
