/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: BkSound.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// BkSound.h: interface for the CBkSound class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BKSOUND_H__A8397426_0E28_4C99_BF06_4EDE805912F7__INCLUDED_)
#define AFX_BKSOUND_H__A8397426_0E28_4C99_BF06_4EDE805912F7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <afxmt.h>
#include <mmsystem.h>
#include <dsound.h>

#include "DST.h"
#include "Defines.h"

//////////////////////////////////////////////////////////////////////
class CBkSound  
{
	enum				{BUFFER_FREQUENCY = 44100};
	enum				{BUFFER_BPS = 8};

	BOOL				m_bEmulateSoundcard;
	
	CComPtr<IDirectSound>		m_pDirectSound;
	CComPtr<IDirectSoundBuffer> m_pBuffer;
	CComPtr<IDirectSoundNotify> m_pNotify;
	DSBPOSITIONNOTIFY*	m_pNotifyPositions;
	HANDLE*				m_pNotifyEvents;
	HANDLE				m_hBufferReadyEvent;
	CCriticalSection	m_csModifyBuffer;

	CWinThread*			m_pNotifyThread;
	
	BOOL				m_bBufferReady;
	BYTE*				m_pSampleBuffer;
	DWORD				m_cpu_sps;

	DSBUFFERDESC		m_BD;
	WAVEFORMATEX		m_wfx;

	BOOL				m_bSoundEnable;

	static void			EventThread (CBkSound* pThis);
	void				InitEvents ();
	
public:

	CBkSound (CWnd* pWnd, DWORD cpu_sps = CPU_SETS_PER_SECOND);
	virtual ~CBkSound ();

	void				WaitAndSendBuffer (BYTE* pBuffer);
	BYTE*				GetSampleBuffer ();
	int					GetSampleCount ();
};

#endif // !defined(AFX_BKSOUND_H__A8397426_0E28_4C99_BF06_4EDE805912F7__INCLUDED_)
