/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: BKMessageBox.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// BKMessageBox.cpp: implementation of the CBKMessageBox class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "bk.h"
#include "BKMessageBox.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

HHOOK CBKMessageBox::m_hHook = NULL;
CBKMessageBox* CBKMessageBox::m_pThis = NULL;


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


CBKMessageBox::CBKMessageBox ()
{
	InstallHook ();
}

CBKMessageBox::CBKMessageBox (LPCTSTR lpszText, UINT nType, UINT nIDHelp)
{
	InstallHook ();

	Show (lpszText, nType, nIDHelp);
}

CBKMessageBox::~CBKMessageBox()
{
	UninstallHook ();
}



/////////////////////////////////////////////////////////////////////////////
BOOL CBKMessageBox::InstallHook ()
{
	if (m_hHook)
		return FALSE;
	
	m_hHook = ::SetWindowsHookEx (WH_CALLWNDPROC, HookProc, NULL, ::GetCurrentThreadId ()); 
	m_pThis = this;

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
BOOL CBKMessageBox::UninstallHook ()
{
	if (!m_hHook)
		return TRUE;

	m_pThis = NULL;
	
	BOOL bRet = ::UnhookWindowsHookEx (m_hHook);
	m_hHook = NULL;

	return bRet;
}



/////////////////////////////////////////////////////////////////////////////
LRESULT CALLBACK CBKMessageBox::HookProc (int code, WPARAM wParam, LPARAM lParam)
{
	if (code == HC_ACTION)
	{
		CWPSTRUCT* pCwp = (CWPSTRUCT*)lParam;

		if (pCwp->message == WM_MOVE)
		{
			CBKDialog::ChangeCommonDialogFont (pCwp->hwnd);	
		}
	}

	return ::CallNextHookEx (m_hHook, code, wParam, lParam);
}



/////////////////////////////////////////////////////////////////////////////
int CBKMessageBox::Show (LPCTSTR lpszText, UINT nType, UINT nIDHelp)
{
	return AfxMessageBox (lpszText, nType, nIDHelp);
}



/////////////////////////////////////////////////////////////////////////////
int	CBKMessageBox::Show (UINT strID, UINT nType, UINT nIDHelp)
{
	CString strMessage;
	strMessage.LoadString (strID);

	return Show (strMessage, nType, nIDHelp);
}