/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: BKMenu.h
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// BKMenu.h: interface for the CBKMenu class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BKMENU_H__024EF864_D632_40E6_A2AC_A06D0A121C22__INCLUDED_)
#define AFX_BKMENU_H__024EF864_D632_40E6_A2AC_A06D0A121C22__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CBKMenu : public CMenu  
{
	BOOL				m_bMain;
	CBKMenu*			m_pSubMenus;

	enum				{TAB_LENGTH = 30};
	enum				{ITEM_HEIGHT = 16};
	enum				{TEXT_LEFT_MARGING = 24};

	void				SetOwnerDrawFlag (CBKMenu* pMenu, BOOL bMain);
	void				DrawItem (LPDRAWITEMSTRUCT lpDrawItemStruct);
	void				DrawItem (CDC* pDC, int itemID, CRect rcItem, BOOL bSelected);
	void				DrawCheckMark (CDC* pDC, CRect rcItem, COLORREF clr);
	void				MeasureItem (LPMEASUREITEMSTRUCT lpMeasureItemStruct);
	
public:
	CBKMenu();
	virtual ~CBKMenu();

	void				Customize (CMenu* pMenu);
	void				CustomizeMain (CMenu* pMain);

	int					GetMenuWidth ();
	int					GetItemWidth (int nItem, UINT fFlag);	
};

#endif // !defined(AFX_BKMENU_H__024EF864_D632_40E6_A2AC_A06D0A121C22__INCLUDED_)
