/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: BKMenu.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// BKMenu.cpp: implementation of the CBKMenu class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "bk.h"
#include "BKMenu.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBKMenu::CBKMenu()
{
	m_bMain = FALSE;
	m_pSubMenus = NULL;
}

CBKMenu::~CBKMenu()
{
	delete []m_pSubMenus;
}



//////////////////////////////////////////////////////////////////////
void CBKMenu::Customize (CMenu* pMenu)
{
	m_bMain = FALSE;

	//ASSERT (!m_hMenu);
	if (!m_hMenu)
		Attach (*pMenu);
	
	SetOwnerDrawFlag (this, m_bMain);
}



//////////////////////////////////////////////////////////////////////
void CBKMenu::CustomizeMain (CMenu* pMenu)
{
	m_bMain = TRUE;

	if (!m_hMenu)
		Attach (*pMenu);

	SetOwnerDrawFlag (this, m_bMain);
}



//////////////////////////////////////////////////////////////////////
void CBKMenu::SetOwnerDrawFlag (CBKMenu* pMenu, BOOL bMain)
{
	int nItems = pMenu->GetMenuItemCount ();

	// For eatch item set ownerdraw flag
	for (int n = 0; n < nItems; n++)
	{
		MENUITEMINFO mi;
		memset (&mi, 0, sizeof (mi));
		mi.cbSize = sizeof (mi);
		mi.fMask = MIIM_FTYPE;
		pMenu->GetMenuItemInfo (n, &mi, TRUE);

		if (m_bMain)
		{
			mi.fMask |= MIIM_ID;
			mi.wID = n + 1;
		}

		mi.fType |= MFT_OWNERDRAW;
		::SetMenuItemInfo (m_hMenu, n, TRUE, &mi);

		mi.fMask = MIIM_SUBMENU;
		pMenu->GetMenuItemInfo (n, &mi, TRUE);
		
		if (mi.hSubMenu)
		{
			// If has submenu - customize it
			if (!m_pSubMenus)
				m_pSubMenus = new CBKMenu[nItems]; // Create empty slots for submenus

			m_pSubMenus[n].Customize (CMenu::FromHandle (mi.hSubMenu));
		}
	}
}



//////////////////////////////////////////////////////////////////////
void CBKMenu::DrawItem (LPDRAWITEMSTRUCT lpDrawItemStruct)
{	
	CDC* pDC = CDC::FromHandle (lpDrawItemStruct->hDC);
	CRect rcItem = lpDrawItemStruct->rcItem;
	UINT nItemID = lpDrawItemStruct->itemID;

	if (lpDrawItemStruct->itemAction & ODA_DRAWENTIRE)
		DrawItem (pDC, nItemID, rcItem, FALSE);

	if ((lpDrawItemStruct->itemState & ODS_SELECTED) && (lpDrawItemStruct->itemAction & (ODA_SELECT | ODA_DRAWENTIRE)))
		DrawItem (pDC, nItemID, rcItem, TRUE);

	if (!(lpDrawItemStruct->itemState & ODS_SELECTED) && (lpDrawItemStruct->itemAction & ODA_SELECT))
		DrawItem (pDC, nItemID, rcItem, FALSE);
}



//////////////////////////////////////////////////////////////////////
void CBKMenu::DrawItem (CDC* pDC, int itemID, CRect rcItem, BOOL bSelected)
{	
	UINT fByPosition = MF_BYCOMMAND;
	UINT fFlags = GetMenuState (itemID, fByPosition);

	CString strItem;
	GetMenuString (itemID, strItem, fByPosition);

	COLORREF clrText = ::GetSysColor (COLOR_MENUTEXT);
	COLORREF cltBkg = m_bMain ? ::GetSysColor (COLOR_3DFACE): ::GetSysColor (COLOR_MENU);
	COLORREF clt3DLight = ::GetSysColor (COLOR_3DHILIGHT);
	COLORREF clt3DShadow = ::GetSysColor (COLOR_3DSHADOW);

	if (bSelected)
	{
		clrText = ::GetSysColor (COLOR_HIGHLIGHTTEXT);
		cltBkg = ::GetSysColor (COLOR_HIGHLIGHT);
	}

	CBrush br;
	br.CreateSolidBrush (cltBkg);

	CBrush* pOldBrush = pDC->SelectObject (&br);
	pDC->PatBlt (rcItem.left, rcItem.top, rcItem.Width (), rcItem.Height (), PATCOPY);
	pDC->SelectObject (pOldBrush);

	CFont* pOldFont = pDC->SelectObject (CBKDialog::GetBKFont ());
	int oldMode = pDC->SetBkMode (TRANSPARENT);
		
	if (m_bMain == FALSE && fFlags & MF_SEPARATOR)
	{
		CRect rcSeparator = rcItem;
		rcSeparator.DeflateRect (0, ITEM_HEIGHT / 2 - 1);
		pDC->DrawEdge (&rcSeparator, EDGE_ETCHED, BF_RECT);
	}
	else
	{	
		CRect rcText = rcItem;
		rcText.DeflateRect (TEXT_LEFT_MARGING, 2, 0, 2);
		
		pDC->SetTextColor (clrText);

		if (fFlags & MF_GRAYED)
			pDC->SetTextColor (clt3DLight);
		
		pDC->DrawText (strItem, &rcText, DT_EXPANDTABS|(DT_TABSTOP|(TAB_LENGTH<<8)));

		if (fFlags & MF_GRAYED)
		{
			pDC->SetTextColor (clt3DShadow);
			rcText.OffsetRect (-1, -1);
			pDC->DrawText (strItem, &rcText, DT_EXPANDTABS|(DT_TABSTOP|(TAB_LENGTH<<8)));
		}
	}

	if (fFlags & MF_CHECKED)
	{
		CRect rcCheck = rcItem;

		COLORREF clrCheck = clrText;
		if (fFlags & MF_GRAYED)
			clrCheck = clt3DLight;

		DrawCheckMark (pDC, rcCheck, clrCheck); 
		
		if (fFlags & MF_GRAYED)
		{
			rcCheck.OffsetRect (-1, -1);
			DrawCheckMark (pDC, rcCheck, clt3DShadow); 
		}
	}

	pDC->SetBkMode (oldMode);
	pDC->SelectObject (pOldFont);
}


//////////////////////////////////////////////////////////////////////
void CBKMenu::DrawCheckMark (CDC* pDC, CRect rcItem, COLORREF clr)
{
	CPen pen;
	pen.CreatePen (PS_SOLID, 1, clr);

	CPoint ptCheck = rcItem.TopLeft ();
	CPen* pOldPen = pDC->SelectObject (&pen);
	
	ptCheck.Offset (10, 5);
	pDC->MoveTo (ptCheck);
	ptCheck.Offset (3, 3);
	pDC->LineTo (ptCheck);
	ptCheck.Offset (6, -6);
	pDC->LineTo (ptCheck);
	
	ptCheck = rcItem.TopLeft ();
	ptCheck.Offset (10, 5 + 1);
	pDC->MoveTo (ptCheck);
	ptCheck.Offset (3, 3);
	pDC->LineTo (ptCheck);
	ptCheck.Offset (6, -6);
	pDC->LineTo (ptCheck);

	ptCheck = rcItem.TopLeft ();
	ptCheck.Offset (10, 5 + 2);
	pDC->MoveTo (ptCheck);
	ptCheck.Offset (3, 3);
	pDC->LineTo (ptCheck);
	ptCheck.Offset (6, -6);
	pDC->LineTo (ptCheck);
	
	pDC->SelectObject (pOldPen);
}


//////////////////////////////////////////////////////////////////////
void CBKMenu::MeasureItem (LPMEASUREITEMSTRUCT lpMeasureItemStruct)
{
	if (!m_bMain)
	{
		lpMeasureItemStruct->itemWidth = GetMenuWidth ();
		lpMeasureItemStruct->itemHeight = ITEM_HEIGHT;
	}
}



//////////////////////////////////////////////////////////////////////
int CBKMenu::GetMenuWidth ()
{
	int width = 0;
	int nItems = GetMenuItemCount ();

	for (int n = 0; n < nItems; n++)
	{
		int nItemLength = GetItemWidth (n, MF_BYPOSITION);
		
		if (nItemLength > width)
			width = nItemLength;
	}

	return width + 20;
}



//////////////////////////////////////////////////////////////////////
int CBKMenu::GetItemWidth (int nItem, UINT fFlag)
{
	CString strItem;
	GetMenuString (nItem, strItem, fFlag);

	int nLength = strItem.GetLength ();
	int nItemLength = 0;
	
	for (int c = 0; c < nLength; c++)
	{
		if (strItem[c] == _T('\t'))
			nItemLength = TAB_LENGTH * 6;
		else
			nItemLength += 6;
	}

	return nItemLength + 20;
}
