/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: BKMainMenu.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// BKMainMenu.cpp : implementation file
//

#include "stdafx.h"
#include "bk.h"
#include "BKMainMenu.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//HHOOK CBKMainMenu::m_hHook = NULL;
//CBKMainMenu* CBKMainMenu::m_pThis = NULL;

/////////////////////////////////////////////////////////////////////////////
// CBKMainMenu

CBKMainMenu::CBKMainMenu()
{
	m_pSubMenus = NULL;
	m_nMenuButton = -1;
}

CBKMainMenu::~CBKMainMenu()
{
	//UninstallHook ();
	delete []m_pSubMenus;
}


BEGIN_MESSAGE_MAP(CBKMainMenu, CToolBarCtrl)
	//{{AFX_MSG_MAP(CBKMainMenu)
	ON_WM_LBUTTONDOWN()
	ON_WM_TIMER()
	ON_MESSAGE (WM_TRACK_NEXT_MENU, OnTrackNextMenu)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBKMainMenu message handlers


BOOL CBKMainMenu::Create (int idMenu, CWnd* pParent)
{
	// Create toolbar
	if (!CToolBarCtrl::Create (WS_CHILD|WS_VISIBLE|CCS_NORESIZE|CCS_NODIVIDER/*|CCS_NOPARENTALIGN*/|TBSTYLE_FLAT, CRect (0, 0, 0, 0), pParent, 0))
		return FALSE;

	// Load specified menu 
	ASSERT (!m_menu.m_hMenu);
	if (!m_menu.LoadMenu (idMenu))
		return FALSE;

	// Calculate pStrings length
	int nItemCount = m_menu.GetMenuItemCount ();
	int nStringsLength = 0;
	ASSERT (!m_pSubMenus);
	m_pSubMenus = new CBKMenu[nItemCount];

	for (int n = 0; n < nItemCount; n++)
	{
		// Add new item length
		CString strItem;
		m_menu.GetMenuString (n, strItem, MF_BYPOSITION);

		nStringsLength += strItem.GetLength () + 1;

		// Customize submenus
		MENUITEMINFO mi;
		memset (&mi, 0, sizeof (mi));
		mi.cbSize = sizeof (mi);
		mi.fMask = MIIM_SUBMENU;
		m_menu.GetMenuItemInfo (n, &mi, TRUE);

		if (mi.hSubMenu)
			// If submenu - customize it
			m_pSubMenus[n].Customize (CMenu::FromHandle (mi.hSubMenu));
	}

	// Allocate memory for pStrings
	nStringsLength++;
	TCHAR* pStrings = new TCHAR[nStringsLength];
	memset (pStrings, 0, sizeof (TCHAR) * nStringsLength);
	int nStringsPos = 0;

	// Add menu items to pStrings
	for (n = 0; n < nItemCount; n++)
	{
		CString strItem;
		m_menu.GetMenuString (n, strItem, MF_BYPOSITION);

		memcpy (&pStrings[nStringsPos], strItem, strItem.GetLength ());
		nStringsPos += strItem.GetLength () + 1;
	}

	AddStrings (pStrings);
	delete []pStrings;

	// Add Buttons to Main menu
	for (n = 0; n < nItemCount; n++)
	{
		TBBUTTON tbbtn;
		memset (&tbbtn, 0, sizeof (tbbtn));
		tbbtn.fsStyle = TBSTYLE_BUTTON;
		tbbtn.iString = n;
		tbbtn.fsState = TBSTATE_ENABLED;
		tbbtn.idCommand = n;

		InsertButton (n, &tbbtn);
		SetBitmapSize (CSize (0, 0));
	}

	// Set BK fonts to buttons
	CBKDialog::ChangeCommonDialogFont (this);

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
void CBKMainMenu::NormalizeState ()
{
	// Set all buttons on normale
	int nButtons = GetButtonCount ();

	for (int n = 0; n < nButtons; n++)
		SetState (n, TBSTATE_ENABLED);
}



/////////////////////////////////////////////////////////////////////////////
void CBKMainMenu::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// Get clicked button
	int nButton = HitTest (&point);

	if (nButton < 0)
		return;

	TrackMenu (nButton);
	
	//CToolBarCtrl::OnLButtonDown(nFlags, point);
}



/////////////////////////////////////////////////////////////////////////////
void CBKMainMenu::TrackMenu (int nButton)
{
	NormalizeState ();

	// Get button rectangle 
	CRect rcBtn;
	GetItemRect (nButton, &rcBtn);

	// Track submenu
	CPoint ptTrack = rcBtn.TopLeft ();
	ptTrack.y += rcBtn.Height ();
	ClientToScreen (&ptTrack);

	// Press button
	SetState (nButton, TBSTATE_ENABLED|TBSTATE_PRESSED);

	m_nMenuButton = nButton;
	//InstallHook ();
	SetTimer (0, 50, NULL);
	
	// Track button menu
	if (m_pSubMenus[nButton].m_hMenu)
		m_pSubMenus[nButton].TrackPopupMenu (TPM_LEFTALIGN, ptTrack.x, ptTrack.y, GetParent ());

	CPoint ptCursor;
	GetCursorPos (&ptCursor);

	CRect rcItem;
	GetItemRect (nButton, &rcItem);
	ClientToScreen (&rcItem);

	if (rcItem.PtInRect (ptCursor))
		m_nMenuButton = -1;
	
	NormalizeState ();
}



/////////////////////////////////////////////////////////////////////////////
int CBKMainMenu::NextMenu (CPoint pt)
{
	int nMenu;
	int nButtons = GetButtonCount ();

	CRect rcLeft;
	CRect rcRight;
	GetItemRect (0, &rcLeft);
	ClientToScreen (&rcLeft);
	GetItemRect (nButtons - 1, &rcRight);
	ClientToScreen (&rcRight);

	if (pt.x <= rcLeft.left) 
		nMenu = 0;

	if (pt.x >= rcRight.right)
		nMenu = nButtons - 1;

	for (int n = 0; n < nButtons; n++)
	{
		CRect rcItem;
		GetItemRect (n, &rcItem);
		ClientToScreen (&rcItem);

		if (pt.x >= rcItem.left && pt.x <= rcItem.right)
		{
			nMenu = n;
			break;
		}
	}

	return nMenu;
}



/////////////////////////////////////////////////////////////////////////////
BOOL CBKMainMenu::LeaveMenu (CPoint pt)
{
	// Get Popup window
	CWnd* pPopup = FindWindow (_T("#32768"), NULL);

	if (!pPopup)
		return FALSE;

	// Get Track window rectangle
	CRect rcClient;
	pPopup->GetWindowRect (&rcClient);

	//TRACE ("\n Point %i, %i", pt.x, pt.y);
	//TRACE ("\n Rect %i, %i, %i, %i", rcClient.left, rcClient.right, rcClient.top, rcClient.bottom);

	if (rcClient.PtInRect (pt))
		// Mouse still on track window - dont touch it
		return FALSE;

	CRect rcBtn;
	GetItemRect (m_nMenuButton, &rcBtn);
	ClientToScreen (&rcBtn);

	if (rcBtn.PtInRect (pt))
		// Mouse on track it button - dont touch it
		return FALSE;
	
	if (NextMenu (pt) == m_nMenuButton)
		return FALSE;

	// Close menu
	GetParent ()->SendMessage (WM_CANCELMODE);

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
void CBKMainMenu::OnTimer(UINT nIDEvent) 
{
	CPoint ptCursor;
	GetCursorPos (&ptCursor);
	
	if (LeaveMenu (ptCursor))
	{
		KillTimer (0);
		PostMessage (WM_TRACK_NEXT_MENU);
	}
			
	CToolBarCtrl::OnTimer(nIDEvent);
}



/////////////////////////////////////////////////////////////////////////////
HRESULT CBKMainMenu::OnTrackNextMenu (WPARAM wParam, LPARAM lParam)
{
	CPoint ptCursor;
	GetCursorPos (&ptCursor);
	
	CRect rcItem;
	GetItemRect (m_nMenuButton, &rcItem);
	ClientToScreen (&rcItem);

	if (!rcItem.PtInRect (ptCursor))
		TrackMenu (NextMenu (ptCursor));

	return TRUE;
}


/*
/////////////////////////////////////////////////////////////////////////////
BOOL CBKMainMenu::InstallHook ()
{
	if (m_hHook)
		return FALSE;
	
	m_hHook = ::SetWindowsHookEx (WH_MSGFILTER, HookProc, NULL, ::GetCurrentThreadId ()); 
	m_pThis = this;

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
BOOL CBKMainMenu::UninstallHook ()
{
	if (!m_hHook)
		return TRUE;

	m_pThis = NULL;
	
	BOOL bRet = ::UnhookWindowsHookEx (m_hHook);
	m_hHook = NULL;

	return bRet;
}



/////////////////////////////////////////////////////////////////////////////
LRESULT CALLBACK CBKMainMenu::HookProc (int code, WPARAM wParam, LPARAM lParam)
{
	if (code == MSGF_MENU)
	{
		MSG* pMsg = (MSG*)lParam;

		if (pMsg->message == WM_MOUSEMOVE)
		{
			CPoint ptCursor = pMsg->pt;

			if (m_pThis->LeaveMenu (ptCursor))
			{
				m_pThis->PostMessage (WM_TRACK_NEXT_MENU);
				m_pThis->UninstallHook ();
				return 1;
			}
		}
	}

	return ::CallNextHookEx (m_hHook, code, wParam, lParam);
}
*/
