/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: BKDialog.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// BKDialog.cpp : implementation file
//

#include "stdafx.h"
#include "bk.h"
#include "BKDialog.h"
#include <afxpriv.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBKDialog dialog

BOOL CBKDialog::bInit = FALSE;
CFont CBKDialog::fontBK;

CBKDialog::CBKDialog (DWORD iID, CWnd* pParent /*=NULL*/)
	: CDialog(CBKDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBKDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_dialogID = iID;
}

CBKDialog::~CBKDialog ()
{
}

void CBKDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBKDialog)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBKDialog, CDialog)
	//{{AFX_MSG_MAP(CBKDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBKDialog message handlers

/////////////////////////////////////////////////////////////////////////////
void CBKDialog::InitializeBKFont ()
{
#ifndef _DEBUG
	if (!bInit)
	{
		// Add own font
		TCHAR pModule[_MAX_PATH];
		::GetModuleFileName (NULL, pModule, _MAX_PATH);
		int nFonts = AddFontResource (pModule);

		// If font not initialized create ot
		fontBK.CreatePointFont (80, _T("BK Emulator Font"));
		bInit = TRUE;
	}

#else
	fontBK.CreatePointFont (80, _T("BK Emulator Font"));
#endif
}



/////////////////////////////////////////////////////////////////////////////
void CBKDialog::UninitializeBKFont ()
{
	if (bInit)
	{
		// Remove own font
		TCHAR pModule[_MAX_PATH];
		::GetModuleFileName (NULL, pModule, _MAX_PATH);
	
		int nFonts = RemoveFontResource (pModule);
		bInit = FALSE;
	}
}



/////////////////////////////////////////////////////////////////////////////
CFont* CBKDialog::GetBKFont ()
{
	return &fontBK;
}



/////////////////////////////////////////////////////////////////////////////
int CBKDialog::DoModal() 
{
	CDialogTemplate dialogTemplate;
	int nResult;
	
	// Load dialog template
	if (!dialogTemplate.Load (MAKEINTRESOURCE (m_dialogID)))
	{
		ASSERT (FALSE);
		return -1;
	}
   
	// Get pointer to the modified dialog template
	LPSTR pdata = (LPSTR)GlobalLock (dialogTemplate.m_hTemplate);
	dialogTemplate.SetFont (_T("BK Emulator Font"), 8);
	
	// Let MFC know that you are using your own template
	m_lpszTemplateName = NULL;
	InitModalIndirect (pdata);
	
	// Display dialog box
	nResult = CDialog::DoModal ();

	// Unlock memory object
	GlobalUnlock (dialogTemplate.m_hTemplate);

	return nResult;
}



/////////////////////////////////////////////////////////////////////////////
BOOL CBKDialog::Create (int iTemplateName, CWnd* pParentWnd)
{
	CDialogTemplate dialogTemplate;
	
	// Load dialog template
	if (!dialogTemplate.Load (MAKEINTRESOURCE (iTemplateName)))
	{
		ASSERT (FALSE);
		return -1;
	}
   
	// Get pointer to the modified dialog template
	LPSTR pdata = (LPSTR)GlobalLock (dialogTemplate.m_hTemplate);
	dialogTemplate.SetFont (_T("BK Emulator Font"), 12);
	
	// Let MFC know that you are using your own template
	m_lpszTemplateName = NULL;

	BOOL bResult = CreateIndirect (dialogTemplate.m_hTemplate, pParentWnd, AfxGetInstanceHandle ());
	
	GlobalUnlock (dialogTemplate.m_hTemplate);

	return bResult;
}



/////////////////////////////////////////////////////////////////////////////
BOOL CBKDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	ChangeCommonDialogFont (this);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}



/////////////////////////////////////////////////////////////////////////////
void CBKDialog::ChangeCommonDialogFont (HWND hDlg, HFONT hFont)
{
	ChangeCommonDialogFont (CWnd::FromHandle (hDlg), CFont::FromHandle (hFont));
}



/////////////////////////////////////////////////////////////////////////////
void CBKDialog::ChangeCommonDialogFont (CWnd* pDlg, CFont* pFont)
{
	ASSERT (pDlg);
	if (!pDlg)
		return;

	CFont* pFontBK = pFont;

	if (!pFontBK)
		pFontBK = &fontBK; // If there is no specified font - set default font

	// Set dialog font
	pDlg->SetFont (pFontBK, TRUE);

	// Get first control
	CWnd* pCtrl = pDlg->GetWindow (GW_CHILD);

	while (pCtrl) // If atleast one child control exists
	{
		// Set font for control
		pCtrl->SetFont (pFontBK, TRUE);

		ChangeCommonDialogFont (pCtrl, pFontBK); // Call recursive for all child

		// Get next control
		pCtrl = pCtrl->GetNextWindow (GW_HWNDNEXT);
	}
}

