/*************************************************
*            BK Emulator for Window 3.0          *
*************************************************/

/*
File: BK.cpp
Version: 1.0.0
Written by: Yuriy Kalmykov <kalmykov@stoik.com>
    Copyright (c) 2002-2004 Yuriy Kalmykov

    BK Emulator is a program emulated hardware environment for running
code for BK 0010(01) in different configurations. 
           
    This code may be used in compiled form in any way you desire.
This file or it's parts can't be redistributed without the authors
written consent, but can be modified for your private needs.
    Providing that this notice and the authors name and all copyright
notices remains intact.

    Please, an email me to know how you are using it and where. You can
ask me for any information about this below code or any attendant
knowledge.
    
    This file is provided "as is" with no expressed or implied warranty.
The author accepts no liability for any damage or loss of business that
this product may cause.
*/




// BK.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "BK.h"
#include "MainFrm.h"
#include "StaticLink.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBKApp

BEGIN_MESSAGE_MAP(CBKApp, CWinApp)
	//{{AFX_MSG_MAP(CBKApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBKApp construction

CBKApp::CBKApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CBKApp object

CBKApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CBKApp initialization

BOOL CBKApp::InitInstance()
{
	AfxEnableControlContainer ();
	AfxOleInit ();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.


#ifdef _AFXDLL
	Enable3dControls ();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic ();	// Call this when linking to MFC statically
#endif


	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	// To create the main window, this code creates a new frame window
	// object and then sets it as the application's main window object.

	CBKDialog::InitializeBKFont ();

	CMainFrame* pFrame = new CMainFrame;
	m_pMainWnd = pFrame;

	// create and load the frame with its resources

	BOOL bCreate = pFrame->LoadFrame (IDR_MAINFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, NULL,
		NULL);

	if (!bCreate)
		return FALSE;

	// The one and only window has been initialized, so show and update it.
	pFrame->ShowWindow(SW_SHOW);
	pFrame->UpdateWindow();

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
int CBKApp::Run() 
{
	// Init main BK Emulator loop
	HACCEL hAccel = ::LoadAccelerators (NULL, MAKEINTRESOURCE (IDR_MAINFRAME));

	while (1)
	{
		// Get current message
		if (!::PeekMessage (&m_msgCur, NULL, NULL, NULL, PM_NOREMOVE))
		{
			// If no message call main emulator loop
			((CMainFrame*)AfxGetMainWnd ())->OnMainLoop (0, 0);
		}
		else
		{
			if (AfxGetMainWnd () && ::TranslateAccelerator (AfxGetMainWnd ()->m_hWnd, hAccel, &m_msgCur))
			{
				::PeekMessage (&m_msgCur, NULL, NULL, NULL, PM_REMOVE);
				continue;
			}

			// If message call default message way
			if (!PumpMessage ())
			{
				return ExitInstance ();
				//return FALSE;
			}
		}
	}
	
	return CWinApp::Run ();
}



/////////////////////////////////////////////////////////////////////////////
int CBKApp::ExitInstance() 
{
#ifndef _DEBUG
	CBKDialog::UninitializeBKFont ();	
#endif

	return CWinApp::ExitInstance();
}



/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CBKDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CStaticLink	m_staticHomePage;
	CStaticLink	m_staticGames;
	CStaticLink	m_staticMail;
	CString	m_strEmulTitle;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CBKDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	m_strEmulTitle = _T("");
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CBKDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_STATIC_HOMEPAGE, m_staticHomePage);
	DDX_Control(pDX, IDC_STATIC_GAMES, m_staticGames);
	DDX_Control(pDX, IDC_STATIC_MAIL, m_staticMail);
	DDX_Text(pDX, IDC_EMUL_TITLE, m_strEmulTitle);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CBKDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CBKApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	
	aboutDlg.m_strEmulTitle.LoadString (IDS_EMUL_TITLE);
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CBKApp message handlers

